qui {

noi {
	/*************************************************/
	/*** Step 2.4.1. Motivating example 		    **/
	/*************************************************/
}

/* 2.4.0. Identify motivating examples in the data */
cd ..
cd ".\4. Master data"
clear all
use master_data
	
	* Motivating example 2: correcting for matching quality
	sum cntrycode if cntry == "Central African Republic"
	local example = `r(mean)'
	noi sum year if independence_years == 0 & cntrycode == `example' & year >= $startyear
	local indepyear = r(mean)
	noi sum year if cntrycode == `example' & baseline_gdpcap != .
	local minyear = max(`indepyear'-31,`r(min)')
	local maxyear = min(`indepyear'+19,`r(max)')
	local min = max(`indepyear'-11,`r(min)')
	local max = min(`indepyear'-1,`r(max)')
	local min2 = max(`indepyear'-16,`r(min)')
	local max2 = min(`indepyear'-6,`r(max)')
		
noi {
	/*****************************************************************/
	/*** Step 2.3. Motivating example (2): Central African Republic	**/
	/*****************************************************************/
}

	/* 2.3.1. Identify NIC in the data */
	* 0. Data preparation
		
		* Identify example
		noi list cntry year mother_country_name if independence_years == 0 & cntrycode == `example'

		* Load master data, keep relevant information
		clear all
		cd ..
		use ".\4. Master data\master_data.dta", clear 	// Load the original data
		keep cntry* region* year independence_year independence_years baseline_*
		
		* Generate necessary variables
		foreach var in IDD tIDD {
			gen `var' = .
			if "`var'" != "IDD" {
				gen `var'_lower = .
				gen `var'_upper = .
				}
			}
	
		* Label variables
		label var IDD "Raw independence dividend estimate"
		label var tIDD "Trend-demeaned independence dividend estimate"
		
	* 1. Estimate & plot raw independence dividend
		
		* Compute raw independence dividends
		noisily di "Independence dividend estimation"
		
			* Generate synthetic trajectory
			 gen synth_gdpcap = .
			 label var synth_gdpcap "Counterfactual per capita GDP (in absence of state fragmentation)"
			 
			* Gather weights of synthetic trajectory
			preserve
			cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.1. Weights"
			use cntry_weights1_`example', clear
			rename _Co_Number cntrycode
			rename _W_Weight weight
			keep cntrycode weight
			save weights, replace
			restore
			
			* Add them to existing data
			cd ..
			cd ..
			cd ..
			cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.1. Weights"
			merge m:1 cntrycode using weights		// Collect weights for synthetic country associated with each NIC
			drop _*
			erase weights.dta
			
			* Compute synthetic trajectory
			gen weighted_gdpcap = weight * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
			sum year if cntrycode == `example' & independence_years == 0 & year >= $startyear
			local yoi = r(mean)
			sum weighted_gdpcap if year == `yoi' & weighted_gdpcap != 0
			local componentparts = r(N)

			foreach year of numlist $startyear /2016 {
				sum weighted_gdpcap if year == `year' & weighted_gdpcap != 0 
				replace synth_gdpcap = r(sum) if cntrycode == `example' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' 
				}
			
			* Compute independence dividend estimate 
			gen synth_lgdpcap = ln(synth_gdpcap)
			replace IDD = baseline_lgdpcap - synth_lgdpcap
			sum synth_lgdpcap if year <= `maxyear'
			local ceiling = 1*`r(max)'
			
		* Plot raw independence dividends
		
			* Plot actual + synthetic trajectory
			cd ..
			cd ..
			cd ..
			cd ".\5. TeX results"
			sort cntry year
			twoway 	(scatteri `ceiling' `max' `ceiling' `min', bcolor(gs12) recast(area)) || ///
					(line baseline_lgdpcap year if year >= `minyear' & year <= `maxyear' & cntrycode == `example', lcolor(gs0)) || ///
					(line synth_lgdpcap year if year >= `minyear' & year <= `maxyear' & cntrycode == `example', lcolor(gs0) lpattern(dash)) || ///	
					,ytitle("log per capita GDP", size(large)) xtitle(Year, size(large)) legend(order(2 "Actual with secession" 3 "Synthetic without secession")) xline(`indepyear', lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white)
			graph export figure5_1.pdf, replace
			
			noi di "Average min discrepancy:"
			noi sum IDD if cntrycode == `example' & independence_years >= -10 & independence_years < 0
			
	* 2. Control for matching quality: Estimate & plot trend-demeaned independence dividend
	
		* Compute trend-demeaned independence dividends
		noisily di "Trend-demeaned independence dividend estimation"
		
			* Compute average discrepancy between actual and synthetic in the pre-independence period
			sum IDD if independence_years >= -10 & independence_years <= -1 & cntrycode == `example'
			local trendcorrection = `r(mean)'
			gen avg_discrepancy = `r(mean)' if independence_years >= -10 & independence_years <= 0 & cntrycode == `example'
			gen synth_corrected = synth_lgdpcap + `trendcorrection'
			
			* Compute trend-demeaned independence dividends 
			sum independence_years if cntrycode == `example' & IDD != .
		
			foreach postindependencewindow of numlist 0/`r(max)' {
				
				* Identify pre- and post-treatment period:
				gen post = .
				replace post = 1 if cntrycode == `example' & independence_years > -1 
				replace post = 0 if cntrycode == `example' & independence_years < 0
				
				* Identify treated country
				gen treatment = .
				replace treatment = 1 if cntrycode == `example'
				
				* Generate interaction
				gen interaction_1 = post * treatment
				
				* Compute trend-demeaned independence dividend
				xi: reg IDD post treatment interaction_1 if cntrycode == `example'  & independence_years > -11 & independence_years < 0  | cntrycode == `example'  & independence_years == `postindependencewindow', robust
				mat results = r(table)
				
				replace tIDD = round(results[1,1],.001) if cntrycode == `example' & independence_years == `postindependencewindow'
				replace tIDD_lower = results[5,1] if cntrycode == `example' & independence_years == `postindependencewindow'
				replace tIDD_upper = results[6,1] if cntrycode == `example' & independence_years == `postindependencewindow'
				
				* Drop unnecesaries
				drop post* treatment* interaction*
				}
			
		* Plot trend-demeaned independence dividends

			* Plot average pre-independence discrepancy between actual and synthetic NIC
			cd ..
			cd ".\5. TeX results"
			sort cntry independence_years
			twoway 	line IDD independence_years if independence_years >= -10 & independence_years <= 20 & cntrycode == `example', lcolor(gs0) || ///
					line avg_discrepancy independence_years if independence_years >= -10 & independence_years <= 20 & cntrycode == `example',  /*text(-.03 0.5 "{bf:}}", size(vlarge))  text(-.04 5.5 "matching quality", justification(right) size(large))*/ legend(off) lpattern(longdash) lcolor(gs0) ytitle("Gap in log per capita GDP", size(large)) xtitle("Years of independence", size(large)) xline(0, lcolor(red) lpattern(dot)) yline(0, lcolor(gs5) lpattern(dot))  graphregion(color(white)) bgcolor(white)
			graph export figure5_2.pdf, replace

			* Plot corrected synthetic trajectory
			sort cntry year
			twoway line baseline_lgdpcap year if year >= `min' & year <= `maxyear' & cntrycode == `example', lcolor(gs0) || ///
				   line synth_lgdpcap year if year >= `min' & year <= `indepyear' & cntrycode == `example', lcolor(gs0) lpattern(dash) || ///
				   line synth_lgdpcap year if year >= `indepyear' & year <= `maxyear' & cntrycode == `example', lcolor(gs8) lpattern(tight_dot) || ///
				   line synth_corrected year if year >= `indepyear' & year <= `maxyear' & cntrycode == `example', lcolor(gs0) lpattern(dash) ytitle("log per capita GDP", size(large)) xtitle(Year, size(large)) legend(order(1 "Actual with secession" 2 "Synthetic without secession"))  xline(`indepyear', lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white)
			graph export figure6_1.pdf, replace
			
			* Plot average pre-independence discrepancy between actual and synthetic NIC
			sort cntry independence_years
			twoway 	line IDD independence_years if independence_years >= -10 & independence_years <= 20 & cntrycode == `example', lcolor(gs0) || ///
					rarea tIDD_upper tIDD_lower independence_years if independence_years >= -10 & independence_years <= 20 & cntrycode == `example', astyle(ci2) acolor(gs14) || ///
					line tIDD independence_years if independence_years >= -10 & independence_years <= 20 & cntrycode == `example', lpattern(longdash) lcolor(gs0) yline(0, lcolor(cranberry) lpattern(dot) lstyle(foreground)) legend(order(1 "Raw" 3 "Trend-demeaned")) lpattern(longdash) lcolor(gs0) ytitle("Gap in log per capita GDP", size(large)) xtitle("Years of independence", size(large)) xline(0, lcolor(red) lpattern(dot)) yline(0, lcolor(gs5) lpattern(dot))  graphregion(color(white)) bgcolor(white)
			graph export figure6_2.pdf, replace
								
	* Reroute to directory containing dofiles
	cd ..
	cd ".\1. Dofiles"
	}
